/*
 * Decompiled with CFR 0.152.
 */
package Schnittstelle;

import Steuerung.Steuerung;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.JOptionPane;

public class LapCounter
implements Runnable {
    private Steuerung steuerung;
    private CommPortIdentifier serialPortId;
    private Enumeration portliste;
    private SerialPort serialPort;
    private InputStream inputStream;
    private OutputStream outputStream;
    private String port;
    private int baudrate = 19200;
    private int databits = 8;
    private int stopbits = 1;
    private int parity = 0;
    private long time = 0L;

    @Override
    public void run() {
        try {
            this.load();
        }
        catch (Exception e) {
            this.MessageDialog("Schnittstelle ist besetzt!");
        }
    }

    public LapCounter(Steuerung steuerungReferenz) {
        System.out.println("G-Lap Lite Zeitmessungssoftware");
        System.out.println("G-Lap LapCounter [Version 0.3.12.06.07]");
        System.out.println("Entwickelt von Christian Torsten Geier");
        System.out.println();
        this.steuerung = steuerungReferenz;
    }

    public void load() throws Exception {
        String dataPort;
        this.port = this.steuerung.getPort();
        this.openPort();
        this.steuerung.StartampelFrame();
        do {
            Thread.sleep(1L);
        } while ((dataPort = this.dataPort("\"H")) != "START" && !this.steuerung.getLapCounterExit());
        this.steuerung.StartampelFrame();
        this.closePort();
        this.openPort();
        this.steuerung.RennmonitorFrame();
        this.time = this.zeitStempel();
        do {
            Thread.sleep(1L);
            dataPort = this.dataPort("\"?");
            if (dataPort == "ID1") {
                this.steuerung.refreshFahrerID1(this.zeitStempel());
            } else if (dataPort == "ID2") {
                this.steuerung.refreshFahrerID2(this.zeitStempel());
            } else if (dataPort == "ID3") {
                this.steuerung.refreshFahrerID3(this.zeitStempel());
            } else if (dataPort == "ID4") {
                this.steuerung.refreshFahrerID4(this.zeitStempel());
            } else if (dataPort == "ID5") {
                this.steuerung.refreshFahrerID5(this.zeitStempel());
            } else if (dataPort == "ID6") {
                this.steuerung.refreshFahrerID6(this.zeitStempel());
            }
            this.steuerung.refreshTime("" + (this.zeitStempel() - this.time) / 1000L);
        } while (!this.steuerung.getLapCounterExit());
        this.closePort();
        this.steuerung.RennmonitorFrame();
        this.steuerung.setLapCounterExit(false);
        System.out.println("G-Lap LapCounter beendet sich...");
    }

    public boolean isRXTXSerialReady() {
        try {
            this.portliste = CommPortIdentifier.getPortIdentifiers();
        }
        catch (Error e) {
            System.out.println("rxtxSerial.dll not found.");
            return false;
        }
        return true;
    }

    public String getPorts() throws Exception {
        String ports = "";
        this.portliste = CommPortIdentifier.getPortIdentifiers();
        while (this.portliste.hasMoreElements()) {
            this.serialPortId = (CommPortIdentifier)this.portliste.nextElement();
            if (this.serialPortId.getPortType() != 1) continue;
            ports = String.valueOf(ports) + this.serialPortId.getName() + " ";
            System.out.println("Found: " + this.serialPortId.getName());
        }
        return ports;
    }

    public void openPort() throws Exception {
        this.portliste = CommPortIdentifier.getPortIdentifiers();
        while (this.portliste.hasMoreElements()) {
            this.serialPortId = (CommPortIdentifier)this.portliste.nextElement();
            if (this.port.contentEquals(this.serialPortId.getName())) break;
        }
        this.serialPort = (SerialPort)this.serialPortId.open(this.port, 500);
        this.serialPort.setSerialPortParams(this.baudrate, this.databits, this.stopbits, this.parity);
        this.inputStream = this.serialPort.getInputStream();
        this.outputStream = this.serialPort.getOutputStream();
    }

    public void closePort() throws Exception {
        this.serialPort.close();
    }

    public String dataPort(String data) throws Exception {
        this.outputStream.write(data.getBytes());
        int inputStreamOrder = this.inputStream.read();
        int inputStreamData = this.inputStream.read();
        if (inputStreamData != 35 && inputStreamData != -1) {
            int inputStreamTrash;
            while ((inputStreamTrash = this.inputStream.read()) != 36 && inputStreamTrash != -1) {
            }
        }
        if (data == "\"H" && inputStreamOrder == 72 && inputStreamData == 48) {
            return "START";
        }
        if (data == "\"?" && inputStreamOrder == 63 && inputStreamData != 35) {
            if (inputStreamData == 49) {
                return "ID1";
            }
            if (inputStreamData == 50) {
                return "ID2";
            }
            if (inputStreamData == 51) {
                return "ID3";
            }
            if (inputStreamData == 52) {
                return "ID4";
            }
            if (inputStreamData == 53) {
                return "ID5";
            }
            if (inputStreamData == 54) {
                return "ID6";
            }
        }
        return "ERROR";
    }

    public long zeitStempel() {
        return System.currentTimeMillis();
    }

    public void MessageDialog(String nachricht) {
        JOptionPane.showMessageDialog(null, nachricht, "G-Lap LapCounter", 0);
    }

    public static void main(String[] args) {
    }
}

