/*
 * Decompiled with CFR 0.152.
 */
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class LapCounter
implements Runnable {
    private Steuerung steuerung;
    CommPortIdentifier serialPortId;
    Enumeration portliste;
    SerialPort serialPort;
    InputStream inputStream;
    OutputStream outputStream;
    String port;
    int baudrate = 19200;
    int databits = 8;
    int stopbits = 1;
    int parity = 0;

    @Override
    public void run() {
        try {
            this.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LapCounter(Steuerung steuerungReferenz) {
        this.steuerung = steuerungReferenz;
    }

    public void load() throws Exception {
        String dataPort;
        this.port = this.steuerung.port;
        this.openPort();
        this.steuerung.StartmonitorFrame();
        do {
            Thread.sleep(10L);
        } while ((dataPort = this.dataPort("\"H")) != "START");
        this.steuerung.StartmonitorFrame();
        this.closePort();
        this.openPort();
        this.steuerung.RennmonitorFrame();
        do {
            Thread.sleep(1L);
            dataPort = this.dataPort("\"?");
            if (dataPort == "ID1") {
                this.steuerung.refreshFahrerID1(this.zeitStempel());
                continue;
            }
            if (dataPort == "ID2") {
                this.steuerung.refreshFahrerID2(this.zeitStempel());
                continue;
            }
            if (dataPort == "ID3") {
                this.steuerung.refreshFahrerID3(this.zeitStempel());
                continue;
            }
            if (dataPort == "ID4") {
                this.steuerung.refreshFahrerID4(this.zeitStempel());
                continue;
            }
            if (dataPort == "ID5") {
                this.steuerung.refreshFahrerID5(this.zeitStempel());
                continue;
            }
            if (dataPort != "ID6") continue;
            this.steuerung.refreshFahrerID6(this.zeitStempel());
        } while (!this.steuerung.lapcounterexit);
        this.closePort();
        this.steuerung.RennmonitorFrame();
        this.steuerung.lapcounterexit = false;
        System.out.println("LapCounter beendet...");
    }

    public void openPort() throws Exception {
        this.portliste = CommPortIdentifier.getPortIdentifiers();
        while (this.portliste.hasMoreElements()) {
            this.serialPortId = (CommPortIdentifier)this.portliste.nextElement();
            if (this.port.contentEquals(this.serialPortId.getName())) break;
        }
        this.serialPort = (SerialPort)this.serialPortId.open(this.port, 500);
        this.serialPort.setSerialPortParams(this.baudrate, this.databits, this.stopbits, this.parity);
        this.inputStream = this.serialPort.getInputStream();
        this.outputStream = this.serialPort.getOutputStream();
    }

    public void closePort() throws Exception {
        this.serialPort.close();
    }

    public String dataPort(String data) throws Exception {
        this.outputStream.write(data.getBytes());
        int inputStreamOrder = this.inputStream.read();
        int inputStreamData = this.inputStream.read();
        if (inputStreamData != 35) {
            while (this.inputStream.read() != 36) {
            }
        }
        if (data == "\"H" && inputStreamOrder == 72 && inputStreamData == 48) {
            return "START";
        }
        if (data == "\"?" && inputStreamOrder == 63 && inputStreamData != 35) {
            if (inputStreamData == 49) {
                return "ID1";
            }
            if (inputStreamData == 50) {
                return "ID2";
            }
            if (inputStreamData == 51) {
                return "ID3";
            }
            if (inputStreamData == 52) {
                return "ID4";
            }
            if (inputStreamData == 53) {
                return "ID5";
            }
            if (inputStreamData == 54) {
                return "ID6";
            }
        }
        return "ERROR";
    }

    public long zeitStempel() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
    }
}

